use std::error::Error;
use std::num::NonZeroUsize;
use std::process::Command;
use std::thread::available_parallelism;

use lexopt::{Arg, Parser, ValueExt};
use jobslot::Client;

fn main() -> Result<(), Box<dyn Error>> {
        let mut command = None;
        let mut jobs = available_parallelism().map_or(4, NonZeroUsize::get);

        let mut parser = Parser::from_env();
        while let Some(arg) = parser.next()? {
                match arg {
                        Arg::Short('j') | Arg::Long("jobs") => {
                                jobs = parser.value()?.parse()?;
                        }
                        Arg::Short(_) | Arg::Long(_) => {
                                println!("Usage: build-server [-j|--jobs=JOBS] <command>");
                                return Ok(());
                        }
                        Arg::Value(cmd) => {
                                command = Some(cmd);
                        }
                }

                if command.is_some() {
                        break;
                }
        }

        let Some(command) = command else {
                println!("Usage: build-server [-j|--jobs=JOBS] <command>");
                return Ok(());
        };

        let mut cmd = Command::new(command);

        for arg in parser.raw_args()? {
                cmd.arg(arg);
        }

        let client = Client::new_with_fifo(jobs)?;
        let status = client.configure_make_and_run_with_fifo(&mut cmd, |cmd| cmd.status())?;

        if status.success() {
                Ok(())
        } else {
                Err("Error occurred while running command".into())
        }
}